require( "scripts/style.lua" );
DebugOut("ChooseScene");

function UpdateSceneList( curUser, numUsers, userTable )

--	EnableWindow( "startat", true )

	for i = 0, numUsers-1 do
		SetLabel( "button"..i, userTable[ i+1 ] );
		EnableWindow( "button"..i, true ) ;
	end

	for i = numUsers, kSceneCount do
		EnableWindow( "button"..i, false ) ;
	end

	if numUsers>0 then
		SetButtonToggleState( "button"..curUser, true );
	end

	DebugOut("UpdateSceneList");
end

NameFont = {
  standardFont,
  24,
  BlackColor
};

HeaderFont = {
  standardFont,
  48,
  BlackColor
};

ButtonX = kCenter;
ButtonY = 0; -- 90;
ButtonYSpace = 26;

-- kSceneCount = 13

NameButtonGraphics = {
	"buttons/choosenameup",
	"buttons/choosenamedown",
	"buttons/choosenameover",
	"buttons/choosenamedown"
};	

NameStyle= {
	type = kRadio,
	flags = kHAlignCenter + kVAlignCenter,
	font = StandardButtonFont,
	graphics = NameButtonGraphics,
	sound = kDefaultButtonSound
};

function AddButtons( N )
	t = { SetStyle(NameStyle), BeginGroup() };
	for i = 0,N-1 do
		table.insert(t,
			Button{
				name="button"..i,
				label="#name",
				x=ButtonX,
				y=ButtonY+(ButtonYSpace*i),
			}
		);	
	end
	return Group(t);
end

function loaderror()
	local answer;
	gDialogTable = { 
		body = "LOADFAILED_body",
		title = "LOADFAILED_title",
		yes = function()
			answer = "yes";
		end;
		no = function()
			answer = "no";
		end;
		};
	DoModal("scripts/ok.lua");
	return answer;
end;

DLGSPEC =
{ 
	image = "backgrounds/largedialog",
	mask = exists("backgrounds/largedialog.mask.png"),
	x = kCenter,
	y = kCenter,
	
	TChooseScene
	{
		x = 0, y = 0, w = kMax, h = kMax,
		
		Text
		{
			font = HeaderFont,
			name = "chooseascene",
			x = 0,y = 50,w = kMax,h = kMax,
			flags = kHAlignCenter + kVAlignTop,
			label = "chooseascene"
		};

		SetStyle(SliderStyle),
--		TSlider
--		{
--			name="vscrollslider",
--			x = 10,
--			y = 60,
--			h = 370,
--		};
		
		TScrolledWindow
		{
			x = 100, y = 100,
			w = kMax - 100, h = 280,
			hslider = false,
			Window 
			{
				w = kMax, h = kSceneCount * ButtonYSpace,
				AddButtons( kSceneCount ),
			},
		},
		
		SetStyle(ThinButtonStyle);

		Button
		{
			x = 70,
			y = 400,
			label = "resume",
			default = true,
			command = StartClose, -- Just close this window
		},

		Button
		{
			x = 190,
			y = 400,
			name = "jumpto",
			label = "jumpto",
			type = kPush,
			command = function()
				if JumpToScene(GetCurrentSelectedScene()) then
					ModalReturn(true);
					QuickClose();
				else
					loaderror();
				end;
			end
		};
			
		Button
		{
			x = 310,
			y = 400,
			name = "startat",
			label = "startat",
			type = kPush,
			command = function()
				if StartAtScene(GetCurrentSelectedScene()) then
					ModalReturn(true);
					QuickClose();
				else
					loaderror();
				end;
			end
		};
	}
}; -- DLGSPEC

MakeDialog
{
	-- Name the modal dialog
	name = "choosescene",
	tTransitionWindow
	{
		x = 0, y = 0, w = kMax, h = kMax, 
		speed_in = slide_speed_in, speed_out = slide_speed_out, accel_in = slice_accel_in, accel_out = slide_accel_out,
		Bitmap(DLGSPEC),
	}
};
